#include <GUIConstantsEx.au3>
#include <GUIListView.au3>
#include 'TCPInet.au3'

Global $iGUI_WIDTH = 500
Global $iGUI_HEIGHT = 300

Global $ahTCPInet[1][2] = [[0]]
Global $sPath = @DesktopDir

$hGUI = GUICreate('TCPInet.au3 Example', $iGUI_WIDTH, $iGUI_HEIGHT)

$iListView = GUICtrlCreateListView('URL|Progress', 20, 20, $iGUI_WIDTH - 40, $iGUI_HEIGHT - 100, $LVS_SHOWSELALWAYS)

$iPauseResume_Bttn = GUICtrlCreateButton('Pause / Resume', 20, $iGUI_HEIGHT - 70, 100, 20)
$iStop_Bttn = GUICtrlCreateButton('Stop', 140, $iGUI_HEIGHT - 70, 60, 20)
$iDownload_Bttn = GUICtrlCreateButton('Download', 20, $iGUI_HEIGHT - 30, 70, 20)
$iLoadFromCB_Bttn = GUICtrlCreateButton('Load URLs from clipboard', $iGUI_WIDTH - 170, $iGUI_HEIGHT - 70, 150, 20)

_Load_URLs()
_GUICtrlsSetState($GUI_ENABLE)
GUISetState(@SW_SHOW, $hGUI)

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			If _TCPInet_GetInfo() = 0 Then
				Exit
			EndIf
			
			If MsgBox(52, 'Attention', 'Are you sure, stop all downloads?', 0, $hGUI) = 6 Then
				$aOpenHandles = _TCPInet_GetOpenHandles()
				
				For $i = 1 To $aOpenHandles[0]
					_TCPInet_Close($aOpenHandles[$i])
				Next
				
				Exit
			EndIf
		Case $iLoadFromCB_Bttn
			_Load_URLs()
		Case $iPauseResume_Bttn
			For $i = 1 To $ahTCPInet[0][0]
				If Not _TCPInet_GetInfo($ahTCPInet[$i][1], $TCPINET_DOWNLOADCOMPLETE) Then
					$bPause = Not _TCPInet_GetInfo($ahTCPInet[$i][1], $TCPINET_DOWNLOADPAUSED)
					_TCPInet_Pause($ahTCPInet[$i][1], $bPause)
				EndIf
			Next
		Case $iStop_Bttn
			For $i = 1 To $ahTCPInet[0][0]
				_TCPInet_Close($ahTCPInet[$i][1])
				
				$sStatus = _GUICtrlListView_GetItemText($iListView, $ahTCPInet[$i][0], 1)
				
				If $sStatus <> '' And $sStatus <> 'Downloaded' Then
					_GUICtrlListView_SetItemText($iListView, $ahTCPInet[$i][0], 'Stopped', 1)
				EndIf
			Next
			
			_GUICtrlsSetState($GUI_ENABLE)
		Case $iDownload_Bttn
			$iCount = _GUICtrlListView_GetItemCount($iListView)
			If $iCount = 0 Then ContinueLoop
			
			$sPath = FileSelectFolder('Save to...', '', 1, $sPath, $hGUI)
			If @error Then ContinueLoop
			
			_GUICtrlsSetState($GUI_DISABLE)
			
			Dim $ahTCPInet[1][2] = [[0]]
			
			For $iIndex = 0 To $iCount - 1
				$sURL = _GUICtrlListView_GetItemText($iListView, $iIndex, 0)
				
				$ahTCPInet[0][0] += 1
				ReDim $ahTCPInet[$ahTCPInet[0][0] + 1][2]
				
				$ahTCPInet[$ahTCPInet[0][0]][0] = $iIndex
				$ahTCPInet[$ahTCPInet[0][0]][1] = _TCPInet_GetFile($sURL, $sPath, True, $TCPINET_DOWNLOADBACKGROUND, '_Download_CallBack', $iIndex)
				
				_GUICtrlListView_SetItemText($iListView, $iIndex, '0% (0/' & _TCPInet_GetInfo($ahTCPInet[$ahTCPInet[0][0]][1], $TCPINET_DOWNLOADSIZE) & ')', 1)
			Next
			
			AdlibRegister('_Check_Finish', 1000)
	EndSwitch
WEnd

Func _Load_URLs()
	Local $aURLs = StringRegExp('http://temp' & @CRLF & ClipGet(), '(https?://[^\s"''\]]+)', 3)
	
	If UBound($aURLs) = 0 Then
		MsgBox(64, 'Title', 'Please put some urls to clipboard', 0, $hGUI)
		Return
	EndIf
	
	$aURLs[0] = UBound($aURLs) - 1
	
	_GUICtrlListView_DeleteAllItems($iListView)
	
	For $i = 1 To $aURLs[0]
		GUICtrlCreateListViewItem($aURLs[$i], $iListView)
	Next
	
	_GUICtrlListView_SetColumnWidth($iListView, 0, 300)
	_GUICtrlListView_SetColumnWidth($iListView, 1, 120)
EndFunc

Func _Check_Finish()
	If _TCPInet_GetInfo() = 0 Then
		AdlibUnRegister('_Check_Finish')
		MsgBox(64, 'Attention', 'Download completed', 0, $hGUI)
		_GUICtrlsSetState($GUI_ENABLE)
	EndIf
EndFunc

Func _GUICtrlsSetState($iState)
	Local $iSwap_State = BitXOR($iState, $GUI_ENABLE, $GUI_DISABLE)
	
	GUICtrlSetState($iPauseResume_Bttn, $iSwap_State)
	GUICtrlSetState($iStop_Bttn, $iSwap_State)
	
	GUICtrlSetState($iDownload_Bttn, $iState)
	GUICtrlSetState($iLoadFromCB_Bttn, $iState)
EndFunc

Func _Download_CallBack($hTCPInet, $iSel_Index)
	Local $aInfo = _TCPInet_GetInfo($hTCPInet)
	
	If @error Or $aInfo[$TCPINET_DOWNLOADPAUSED] Or $aInfo[$TCPINET_DOWNLOADCOMPLETE] Then
		If $aInfo[$TCPINET_DOWNLOADCOMPLETE] Then
			_GUICtrlListView_SetItemText($iListView, $iSel_Index, 'Downloaded', 1)
		EndIf
		
		Return $TCPINET_CB_CONTINUE ;Do nothing (1 to pause, 2 to resume from pause, 3 to close the download handle)
	EndIf
	
	If Not $aInfo[$TCPINET_DOWNLOADPAUSED] Then
		Local $iProgress = Int(100 / ($aInfo[$TCPINET_DOWNLOADSIZE] / $aInfo[$TCPINET_DOWNLOADREAD]))
		
		If $iProgress < 0 Then
			$iProgress = 0
		EndIf
		
		Local $sProgress = StringFormat('%i% (%i/%i)', $iProgress, $aInfo[$TCPINET_DOWNLOADREAD], $aInfo[$TCPINET_DOWNLOADSIZE])
		_GUICtrlListView_SetItemText($iListView, $iSel_Index, $sProgress, 1)
	EndIf
EndFunc
